
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  05 June 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_RC4.c#1:csrc:1
   *  \author R.Levin
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

#include "DX_VOS_Mem.h"
#include "CRYS.h"
#include "CRYS_RC4_error.h"
#include "dx_hw_defs.h"
#include "crys_host_op_code.h"


/************************ Defines ***************************************/

/* canceling the lint warning:
   Use of goto is deprecated */
/*lint --e{801} */


/************************ Enums *****************************************/


/************************ Macros ****************************************/
 

/************************ Public Functions ******************************/

/**
 * @brief This function is used to initialize the RC4 machine.
 *        To operate the RC4 machine, this should be the first function called.      
 *
 * @param[in] ContextID_ptr - A pointer to the RC4 context buffer that is allocated by the user 
 *                       and is used for the RC4 machine operation.
 * @param[in] Key_ptr -  A pointer to the user's key buffer.
 * @param[in] KeySize - The size of the KEY in bytes. Requirements:
 *             - for SW implementation    0 < KeySize < CRYS_RC4_MAX_KEY_SIZE_IN_BYTES,
 *             - for HW implementation    LLF_RC4_MIN_KEY_SIZE_IN_BYTES  < KeySize < LLF_RC4_MAX_KEY_SIZE_IN_BYTES,
 *
 * @return CRYSError_t - CRYS_OK,
 *                       CRYS_RC4_INVALID_USER_CONTEXT_POINTER_ERROR,
 *                       CRYS_RC4_ILLEGAL_KEY_SIZE_ERROR,
 *                       CRYS_RC4_INVALID_KEY_POINTER_ERROR
 */

CEXPORT_C CRYSError_t  CRYS_RC4_Init( CRYS_RC4UserContext_t    *ContextID_ptr,
                                      DxUint8_t                *Key_ptr, 
                                      DxUint32_t                KeySizeInBytes)
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RC4_INIT_OP_CODE, 3,
	   							 /* PARAMETERS: */
                                 ContextID_ptr,
								 Key_ptr, KeySizeInBytes );
  
}/* END OF CRYS_RC4_Init */                  		     


/******************************************************************************************************/
/**
 * @brief This function is used to process a stream on the RC4 machine.
 *        This function should be called after the CRYS_RS4_Init. 
 *      
 *
 * @param[in] ContextID_ptr - A pointer to the RC4 context buffer allocated by the user 
 *                       that is used for the RC4 machine operation. This should be the 
 *                       same context as was used for the previous call of this session.
 *
 * @param[in] DataIn_ptr - The pointer to the buffer of the input data to the RC4. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * @param[in] DataInSize - The size of the input data.
 *
 * @param[in,out] DataOut_ptr - The pointer to the buffer of the output data from the RC4. 
 *                        The pointer's value does not need to be word-aligned.  
 *
 * @return CRYSError_t - CRYS_OK,
 *                       CRYS_RC4_INVALID_USER_CONTEXT_POINTER_ERROR,
 *                       CRYS_RC4_USER_CONTEXT_CORRUPTED_ERROR,
 *                       CRYS_RC4_DATA_IN_POINTER_INVALID_ERROR,
 *                       CRYS_RC4_DATA_OUT_POINTER_INVALID_ERROR,
 *                       CRYS_RC4_DATA_OUT_DATA_IN_OVERLAP_ERROR,
 *                       CRYS_RC4_DATA_SIZE_ILLEGAL
 */
 CEXPORT_C CRYSError_t  CRYS_RC4_Stream(
	                          CRYS_RC4UserContext_t        *ContextID_ptr,   
                              DxUint8_t                    *DataIn_ptr,                                  
                              DxUint32_t                    DataInSize,
                              DxUint8_t                    *DataOut_ptr)
 {                                
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RC4_STREAM_OP_CODE, 4,
	   							 /* PARAMETERS: */
                                 ContextID_ptr,
								 DataIn_ptr, DataInSize,
								 DataOut_ptr );

 }/* END OF CRYS_RC4_Stream */


/******************************************************************************************************/
/**
 * @brief This function is used to end the RC4 processing session.
 *        It is the last function called for the RC4 process.
 *      
 *
 * @param[in] ContextID_ptr - A pointer to the RC4 context buffer allocated by the user that
 *                       is used for the RC4 machine operation. This should be the 
 *                       same context as was used for the previous call of this session.
 *
 *
 * @return CRYSError_t -  CRYS_OK, 
 *                        CRYS_RC4_INVALID_USER_CONTEXT_POINTER_ERROR,
 *                        CRYS_RC4_USER_CONTEXT_CORRUPTED_ERROR
 */
 CEXPORT_C CRYSError_t  CRYS_RC4_Free(CRYS_RC4UserContext_t  *ContextID_ptr )
 {
  /* The return error identifier */
  CRYSError_t   Error;

  /*--------------------------
      CODE
  ----------------------------*/
  
  Error = CRYS_OK;
                   
  /* ............... checking the parameters validity ................... */
   
  /* if the users context ID pointer is DX_NULL return an error */
  if( ContextID_ptr == DX_NULL )
  {
    Error = CRYS_RC4_INVALID_USER_CONTEXT_POINTER_ERROR;
    goto end_function;
  } 
   
   
  /* .............. clearing the users context .......................... */
  /* -------------------------------------------------------------------- */
   
  DX_VOS_MemSet( ContextID_ptr , 0 , sizeof(CRYS_RC4UserContext_t) );   

  /* ................. end of function ..................................... */
  /* ----------------------------------------------------------------------- */
    
end_function:
   
   return Error;   

 }/* END OF CRYS_RC4_Free */


/***********************************************************************************************/
/**
 * \brief This function provides a RC4 operation for processing one continuous block of data.
 *
 *        The function performs RC4 operation  by calling CRYS_RC4_Init, CRYS_RC4_Stream and 
 *        CRYS_RC4_Free functions.
 *
 * @param[in] Key_ptr -  A pointer to the user's key buffer.
 *
 * @param[in] KeySize - The size of the KEY in bytes.
 *
 * @param[in] DataIn_ptr - The pointer to the buffer of the input data to the RC4. 
 *                   The pointer's value does not need to be word-aligned.
 *
 * @param[in] DataInSize - The size of the input data.
 *
 * @param[in,out] The pointer to the buffer of the output data from the RC4.
 *                The pointer's value does not need to be word-aligned. The size of this buffer
 *                must be the same as the DataIn buffer.  
 *
 * @return CRYSError_t -  On success the function returns the value CRYS_OK, 
 *				and on failure a value from CRYS_RC4_error.h
 *
 */
CEXPORT_C    CRYSError_t CRYS_RC4( DxUint8_t   *Key_ptr, 
							      DxUint32_t    KeySizeInBytes,
								  DxUint8_t    *DataIn_ptr, 
								  DxUint32_t    DataInSize,
								  DxUint8_t    *DataOut_ptr )  
{                         
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RC4_OP_CODE, 5,
	   							 /* PARAMETERS: */
                                 Key_ptr, KeySizeInBytes,
								 DataIn_ptr, DataInSize,
								 DataOut_ptr );
}/* END OF CRYS_RC4 */

